/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.Messages;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CommonOccurrencesUpdater
implements IPropertyChangeListener {
    private static final String ANNOTION_ID = "com.aptana.editor.common.occurrence";
    private static final String ANNOTION_DESCRIPTION = Messages.CommonOccurrencesUpdater_Word_Occurrence_Description;
    private AbstractThemeableEditor editor;
    private ISelectionListener selectionListener;
    private IPreferenceStore preferenceStore;
    private Annotation[] annotations;
    private FindOccurrencesJob findOccurrencesJob;
    private CancelerJob cancelerJob;

    public CommonOccurrencesUpdater(AbstractThemeableEditor editor) {
        this.editor = editor;
    }

    private Pattern createWordPattern(String text) {
        String regexSource = "";
        if (Character.isUnicodeIdentifierPart(text.charAt(0))) {
            regexSource = String.valueOf(regexSource) + "\\b";
        }
        regexSource = String.valueOf(regexSource) + Pattern.quote(text);
        if (Character.isUnicodeIdentifierPart(text.charAt(text.length() - 1))) {
            regexSource = String.valueOf(regexSource) + "\\b";
        }
        return Pattern.compile(regexSource);
    }

    protected IAnnotationModel getAnnotationModel() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        IEditorInput editorInput = this.getEditorInput();
        IAnnotationModel result = null;
        if (documentProvider != null && editorInput != null) {
            result = documentProvider.getAnnotationModel((Object)editorInput);
        }
        return result;
    }

    private Object getAnnotationModelLock(IAnnotationModel annotationModel) {
        Object lock;
        Object result = annotationModel;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            result = lock;
        }
        return result;
    }

    protected IDocument getDocument() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument result = null;
        if (sourceViewer != null) {
            result = sourceViewer.getDocument();
        }
        return result;
    }

    protected IDocumentProvider getDocumentProvider() {
        return this.editor.getDocumentProvider();
    }

    protected IEditorInput getEditorInput() {
        return this.editor.getEditorInput();
    }

    protected ISelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (part == CommonOccurrencesUpdater.this.editor) {
                        CommonOccurrencesUpdater.this.updateAnnotations(selection);
                    }
                }
            };
        }
        return this.selectionListener;
    }

    protected ISelectionService getSelectionService() {
        return this.editor.getSite().getWorkbenchWindow().getSelectionService();
    }

    protected ISourceViewer getSourceViewer() {
        return this.editor.getISourceViewer();
    }

    public void initialize(IPreferenceStore store) {
        this.preferenceStore = store;
        if (this.editor.isMarkingOccurrences()) {
            this.install();
            this.updateAnnotations(this.getSelectionService().getSelection());
        }
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        if (this.preferenceStore != null) {
            this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.preferenceStore = null;
        }
        this.uninstall();
    }

    protected void install() {
        this.getSelectionService().addPostSelectionListener(this.getSelectionListener());
        if (this.cancelerJob == null) {
            this.cancelerJob = new CancelerJob();
            this.cancelerJob.install();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("com.aptana.editor.common.editorMarkOccurrences".equals(property)) {
            ISelectionProvider selectionProvider;
            boolean newBooleanValue = false;
            Object newValue = event.getNewValue();
            if (newValue != null) {
                newBooleanValue = Boolean.valueOf(newValue.toString());
            }
            if (newBooleanValue) {
                this.install();
            } else {
                this.uninstall();
            }
            if (this.editor != null && (selectionProvider = this.editor.getSelectionProvider()) != null) {
                this.updateAnnotations(selectionProvider.getSelection());
            }
        }
    }

    protected void uninstall() {
        if (this.selectionListener != null) {
            this.getSelectionService().removePostSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
        if (this.findOccurrencesJob != null) {
            this.findOccurrencesJob.cancel();
            this.findOccurrencesJob = null;
        }
        if (this.cancelerJob != null) {
            this.cancelerJob.uninstall();
            this.cancelerJob = null;
        }
    }

    protected void updateAnnotations(ISelection selection) {
        if (this.findOccurrencesJob != null) {
            this.findOccurrencesJob.cancel();
        }
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            IDocument document = this.getDocument();
            IAnnotationModel annotationModel = this.getAnnotationModel();
            if (document != null && annotationModel != null) {
                this.findOccurrencesJob = new FindOccurrencesJob(document, textSelection, annotationModel);
                this.findOccurrencesJob.schedule();
            }
        }
    }

    private class CancelerJob
    implements IDocumentListener,
    ITextInputListener {
        private CancelerJob() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (CommonOccurrencesUpdater.this.findOccurrencesJob != null) {
                CommonOccurrencesUpdater.this.findOccurrencesJob.cancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null) {
                oldInput.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput != null) {
                newInput.addDocumentListener((IDocumentListener)this);
            }
        }

        public void install() {
            ISourceViewer sourceViewer = CommonOccurrencesUpdater.this.getSourceViewer();
            IDocument document = CommonOccurrencesUpdater.this.getDocument();
            if (sourceViewer != null) {
                sourceViewer.addTextInputListener((ITextInputListener)this);
            }
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            ISourceViewer sourceViewer = CommonOccurrencesUpdater.this.getSourceViewer();
            IDocument document = CommonOccurrencesUpdater.this.getDocument();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if (document != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }
    }

    private class FindOccurrencesJob
    extends Job {
        private IDocument document;
        private ITextSelection selection;
        private IAnnotationModel model;

        public FindOccurrencesJob(IDocument document, ITextSelection selection, IAnnotationModel model) {
            super(Messages.CommonOccurrencesUpdater_Mark_Word_Occurrences);
            this.document = document;
            this.selection = selection;
            this.model = model;
        }

        protected String getWord() {
            String result = null;
            try {
                char c;
                int offset = this.selection.getOffset();
                int length = this.document.getLength();
                int start = offset;
                if (Character.isUnicodeIdentifierPart(this.document.getChar(offset))) {
                    while (offset >= 0) {
                        c = this.document.getChar(offset);
                        if (!Character.isUnicodeIdentifierPart(c)) break;
                        start = offset--;
                    }
                }
                if (Character.isUnicodeIdentifierPart(this.document.getChar((offset = this.selection.getOffset() + this.selection.getLength()) - 1))) {
                    while (offset < length) {
                        c = this.document.getChar(offset);
                        if (!Character.isUnicodeIdentifierPart(c)) break;
                        ++offset;
                    }
                }
                if (this.document.getLineOfOffset(start) == this.document.getLineOfOffset(offset)) {
                    result = this.document.get(start, offset - start);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return result != null ? result.trim() : result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            String word;
            IStatus status = Status.OK_STATUS;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>();
            if (CommonOccurrencesUpdater.this.editor.isMarkingOccurrences() && (word = this.getWord()) != null && word.length() > 0) {
                String source = this.document.get();
                Pattern wordPattern = CommonOccurrencesUpdater.this.createWordPattern(word);
                Matcher matcher = wordPattern.matcher(source);
                while (matcher.find()) {
                    if (monitor.isCanceled()) {
                        status = Status.CANCEL_STATUS;
                        break;
                    }
                    int start = matcher.start();
                    int length = matcher.end() - start;
                    annotationMap.put(new Annotation(CommonOccurrencesUpdater.ANNOTION_ID, false, ANNOTION_DESCRIPTION), new Position(start, length));
                }
            }
            if (status == Status.OK_STATUS) {
                Object object = CommonOccurrencesUpdater.this.getAnnotationModelLock(this.model);
                synchronized (object) {
                    if (this.model instanceof IAnnotationModelExtension) {
                        ((IAnnotationModelExtension)this.model).replaceAnnotations(CommonOccurrencesUpdater.this.annotations, annotationMap);
                    }
                    CommonOccurrencesUpdater.this.annotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
                }
            }
            return status;
        }
    }
}

